<?php
require __DIR__ . '/vendor/autoload.php';

use Http\Client\Common\Plugin\HeaderDefaultsPlugin;
use ZarinPal\Sdk\ClientBuilder;
use ZarinPal\Sdk\Options;
use ZarinPal\Sdk\ZarinPal;
use ZarinPal\Sdk\Endpoint\PaymentGateway\RequestTypes\VerifyRequest;
use ZarinPal\Sdk\HttpClient\Exception\ResponseException;

$clientBuilder = new ClientBuilder();
$clientBuilder->addPlugin(new HeaderDefaultsPlugin([
    'Accept' => 'application/json',
]));

$options = new Options([
    'client_builder' => $clientBuilder,
    'sandbox' => false,
    'merchant_id' => '892adf94-5828-4768-ba63-64c22b682f69',
]);

$zarinpal = new ZarinPal($options);
$paymentGateway = $zarinpal->paymentGateway();

$authority = $_GET['Authority'] ?? null;
$status = $_GET['Status'] ?? null;

if ($status === 'OK' && $authority) {
    $verifyRequest = new VerifyRequest();
    $verifyRequest->authority = $authority;
    $verifyRequest->amount = 10000;

    try {
        $response = $paymentGateway->verify($verifyRequest);

        if ($response->code === 100) {
            echo "<h2 style='color:green'>پرداخت موفق ✅</h2>";
            echo "کد رهگیری: <b>{$response->ref_id}</b><br>";
            echo "شماره کارت: {$response->card_pan}<br>";
        } elseif ($response->code === 101) {
            echo "<h3 style='color:orange'>این پرداخت قبلاً تأیید شده است.</h3>";
        } else {
            echo "<h3 style='color:red'>تراکنش ناموفق با کد: {$response->code}</h3>";
        }

    } catch (ResponseException $e) {
        echo "خطا از سمت زرین‌پال: ";
        var_dump($e->getErrorDetails());
    } catch (Exception $e) {
        echo "خطای داخلی: " . $e->getMessage();
    }

} else {
    echo "پرداخت توسط کاربر لغو شد یا نامعتبر است.";
}
