<?php
require __DIR__ . '/vendor/autoload.php';

use Http\Client\Common\Plugin\HeaderDefaultsPlugin;
use ZarinPal\Sdk\ClientBuilder;
use ZarinPal\Sdk\Options;
use ZarinPal\Sdk\ZarinPal;
use ZarinPal\Sdk\Endpoint\PaymentGateway\RequestTypes\RequestRequest;
use ZarinPal\Sdk\HttpClient\Exception\ResponseException;

$clientBuilder = new ClientBuilder();
$clientBuilder->addPlugin(new HeaderDefaultsPlugin([
    'Accept' => 'application/json',
]));

$options = new Options([
    'client_builder' => $clientBuilder,
    'sandbox' => false,
    'merchant_id' => '892adf94-5828-4768-ba63-64c22b682f69',
]);

$zarinpal = new ZarinPal($options);
$paymentGateway = $zarinpal->paymentGateway();

$request = new RequestRequest();
$request->amount = 10000;
$request->mobile = '09120987654';
$request->email = 'test@example.com';
$request->description = "خرید اشتراک ویژه در سایت Celebritiy.ir";
$request->callback_url = "https://celebritiy.ir/zarinpal/payment/verify.php";

try {
    $response = $paymentGateway->request($request);
    $url = $paymentGateway->getRedirectUrl($response->authority);
    header('Location: ' . $url);
    exit;
} catch (ResponseException $e) {
    echo "خطای پاسخ زرین‌پال: ";
    var_dump($e->getErrorDetails());
} catch (Exception $e) {
    echo "خطا: " . $e->getMessage();
}
